// ========================================
// CARRUSEL DE EGRESADOS
// ========================================

let currentSlideEgresados = 0;
const totalSlidesEgresados = 3;
let autoPlayEgresados;

// Función para cambiar de slide
function changeSlideEgresados(direction) {
    const slides = document.querySelectorAll('.carousel-slide-egresados');
    const indicators = document.querySelectorAll('.carousel-indicator-egresados');

    if (slides.length === 0) return;

    // Ocultar slide actual
    slides[currentSlideEgresados].style.opacity = '0';
    slides[currentSlideEgresados].style.zIndex = '1';
    indicators[currentSlideEgresados].classList.remove('active');

    // Calcular nuevo slide
    currentSlideEgresados += direction;

    // Loop
    if (currentSlideEgresados >= totalSlidesEgresados) {
        currentSlideEgresados = 0;
    } else if (currentSlideEgresados < 0) {
        currentSlideEgresados = totalSlidesEgresados - 1;
    }

    // Mostrar nuevo slide
    slides[currentSlideEgresados].style.opacity = '1';
    slides[currentSlideEgresados].style.zIndex = '2';
    indicators[currentSlideEgresados].classList.add('active');

    // Reiniciar autoplay
    resetAutoPlayEgresados();
}

// Función para ir a un slide específico
function goToSlideEgresados(index) {
    const slides = document.querySelectorAll('.carousel-slide-egresados');
    const indicators = document.querySelectorAll('.carousel-indicator-egresados');

    if (slides.length === 0 || index < 0 || index >= totalSlidesEgresados) return;

    // Ocultar slide actual
    slides[currentSlideEgresados].style.opacity = '0';
    slides[currentSlideEgresados].style.zIndex = '1';
    indicators[currentSlideEgresados].classList.remove('active');

    // Ir al slide seleccionado
    currentSlideEgresados = index;

    // Mostrar nuevo slide
    slides[currentSlideEgresados].style.opacity = '1';
    slides[currentSlideEgresados].style.zIndex = '2';
    indicators[currentSlideEgresados].classList.add('active');

    // Reiniciar autoplay
    resetAutoPlayEgresados();
}

// Función para iniciar el autoplay
function startAutoPlayEgresados() {
    autoPlayEgresados = setInterval(function() {
        changeSlideEgresados(1);
    }, 5000); // Cambiar cada 5 segundos
}

// Función para reiniciar el autoplay
function resetAutoPlayEgresados() {
    clearInterval(autoPlayEgresados);
    startAutoPlayEgresados();
}

// Iniciar cuando carga la página
document.addEventListener('DOMContentLoaded', function() {
    // Verificar que existan los elementos del carrusel
    const carousel = document.querySelector('.egresados-carousel');
    const slides = document.querySelectorAll('.carousel-slide-egresados');

    if (carousel && slides.length > 0) {
        // Iniciar autoplay del carrusel
        startAutoPlayEgresados();

        // Pausar autoplay cuando el mouse está sobre el carrusel
        carousel.addEventListener('mouseenter', function() {
            clearInterval(autoPlayEgresados);
        });

        carousel.addEventListener('mouseleave', function() {
            startAutoPlayEgresados();
        });

        // Soporte para gestos táctiles en móviles
        let touchStartX = 0;
        let touchEndX = 0;

        carousel.addEventListener('touchstart', function(e) {
            touchStartX = e.changedTouches[0].screenX;
        });

        carousel.addEventListener('touchend', function(e) {
            touchEndX = e.changedTouches[0].screenX;
            handleSwipe();
        });

        function handleSwipe() {
            if (touchEndX < touchStartX - 50) {
                // Swipe left - siguiente
                changeSlideEgresados(1);
            }
            if (touchEndX > touchStartX + 50) {
                // Swipe right - anterior
                changeSlideEgresados(-1);
            }
        }

        console.log('Carrusel de egresados inicializado correctamente');
    } else {
        console.warn('No se encontró el carrusel o no tiene slides');
    }
});
